
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : GaussianDistributionTest.pov
 Version     : 3.7
 Description :  

               
 Date        : December 2014
 Author      : Thomas de Groot
 E-mail      : 
 
 Copyright (C) 2014. All rights reserved.
**********************************************************************************/

#version 3.7;

#include "colors.inc"
#include "rand.inc"
#include "functions.inc"
#include "transforms.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <6.0, 2.5, -8.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

//=====================================================================================================================================
plane {
  y, -2
  pigment { color rgb <0.7,0.5,0.3> }
}

// example:
/*#declare MaxRad = 1;
#declare Counter=0;
#declare TotalAmount=100;

#while (Counter<=TotalAmount)

#declare Pos=vrotate(<MaxRad,0,0>,y*(360/.618*Counter))*sqrt(Counter/TotalAmount);
sphere{Pos,.03 pigment{rgb 0.5}}

#declare Counter=Counter+1;
#end*/

//-------------------------------------------------------------
#local Sphere =
sphere {0, 0.015}

#declare Seed = seed(193726);
#declare Number = 5000;

#switch (1)
//-------------------------------------------------------------
//using code from Mark Wagner's vegetate.inc
//and rand macro from rand.inc
//Rand_Gauss(Mu, Sigma, Stream)
//Mu=mean; Sigma=standard deviation; Stream=random number

#case(1)
#debug "\nDistribution 1\n\n"

#local MinBox = <-1.5, -1.5, -1.5>;
#local MaxBox = <1.5, 1.5, 1.5>;
#local Scale  = <0.5, 1.0, 0.5>;

#local Box =
box {MinBox, MaxBox no_shadow}
//sphere {0, MaxBox.y no_shadow}

object {Box pigment {rgb <0.0, 0.5, 0.0> transmit 0.8}}

//Convert bounding box into ranges
#local Xrange = MaxBox.x - MinBox.x;
#local Yrange = MaxBox.y - MinBox.y;
#local Zrange = MaxBox.z - MinBox.z;

union {
#for (N,0,Number)
	//#local PosX = Rand_Gauss(0.5, 0.15, Seed)*Xrange + MinBox.x;
	//#local PosY = Rand_Gauss(0.5, 0.15, Seed)*Yrange + MinBox.y;
	//#local PosZ = Rand_Gauss(0.5, 0.15, Seed)*Zrange + MinBox.z;
	#local PosX = Rand_Cauchy(0.5, 0.15, Seed)*Xrange-MaxBox.y;
	#local PosY = Rand_Cauchy(0.5, 0.15, Seed)*Yrange-MaxBox.y;
	#local PosZ = Rand_Cauchy(0.5, 0.15, Seed)*Zrange-MaxBox.y;
  #local Pos  = <PosX, PosY, PosZ>;//*Scale;
  object {Sphere translate Pos}
#end
 pigment {srgb 0.5}
}

//-------------------------------------------------------------
#break
#case(2)
#debug "Distribution 2\n\n"

union {
#for(N,0,Number)
  #local Pos = <0, 1.5,0>;
  object {Sphere 
    translate Pos
    rotate RRand(-180,180,Seed)*z
    translate <Rand_Gauss(0,0.1,Seed),Rand_Gauss(0,0.1,Seed),Rand_Gauss(0,0.1,Seed)>
  }
#end
 pigment {srgb <1,0,0>}
}

//-------------------------------------------------------------
#break
#case(3)
#debug "Distribution 3\n\n"

#declare Number = (2*pi*2)/0.02;//circle length devided by object diameter
#declare Ang0 = 360/Number;
#local Seed2 = seed(328943);
#local Cyl = cylinder {<0,-1,0>,<0,1,0>,0.01};
union {
  #for(N,0,360,Ang0)
    #local Pos = <2.0, 0, 0>;
    /*object {Sphere
      translate Pos
      rotate RRand(-180*Rand_Gauss(0,1,Seed),180*Rand_Gauss(0,1,Seed),Seed)*y
      translate <0, 0.25+Rand_Gauss(0,0.15,Seed2), 0>
    }*/
    object {Cyl
      scale <1,Rand_Gauss(0,0.15,Seed2),1>
      #local Pos = vaxis_rotate(Pos,<0,10e4,0>,N);
      //rotate RRand(-180/**Rand_Gauss(0,1,Seed)*/,180/**Rand_Gauss(0,1,Seed)*/,Seed)*y
      //rotate N*y
      translate Pos
      translate 0.25*y
    }
  #end
  pigment {srgb <0,1,0>}
}

//-------------------------------------------------------------
/*
Octaves:
The octaves keyword may be followed by an integer value to control the number of steps of turbulence that are computed. 
Legal values range from 1 to <10. The default value of 6 is a fairly high value; you will not see much change by setting 
it to a higher value because the extra steps are too small. Float values are truncated to integer. Smaller numbers of 
octaves give a gentler, wavy turbulence and computes faster. Higher octaves create more jagged or fuzzy turbulence and 
takes longer to compute.

Lambda:
The lambda parameter controls how statistically different the random move of an octave is compared to its previous octave. 
The default value is 2.0 which is quite random. Values close to lambda 1.0 will straighten out the randomness of the path 
in the diagram above. The zig-zag steps in the calculation are in nearly the same direction. Higher values can look more 
swirly under some circumstances.

Omega:
The omega value controls how large each successive octave step is compared to the previous value. Each successive octave 
of turbulence is multiplied by the omega value. The default omega 0.5 means that each octave is 1/2 the size of the previous 
one. Higher omega values mean that 2nd, 3rd, 4th and up octaves contribute more turbulence giving a sharper, crinkly look 
while smaller omegas give a fuzzy kind of turbulence that gets blurry in places.
*/
#break
#case(4)
#debug "Distribution 4\n"

#declare Radius = 0.01;
#declare R = 2.0;
#declare Number = (2*pi*R)/(Radius*2);//circle length devided by object diameter
#declare Ang0 = 360/Number;
#local Seed2 = seed(328943);
#local Cyl = cylinder {<0,-1,0>,<0,1,0>,Radius};
#local N = 0;
#local Frequency = 1.5;
#local Amplitude0 = 1; //or a variable one, below
#local Octaves = 2; //default 6
#local Lambda  = 2; //default 2
#local Omega   = 0.1; //default 0.5

union {
  #while(N<=360)
    #local Pos = <R, 0, 0>;
    object {Cyl
      #local Pos = vaxis_rotate(Pos,<0,-10e4,0>,N);
      #local Amplitude = Amplitude0*RRand(0.99, 1.01, Seed2);
      #local Scale = vturbulence(Lambda, Omega, Octaves, Pos*Frequency)*Amplitude;//multiply by amplitude
      #if (sgn(Scale.y) = -1) #local Scale=<Scale.x,Scale.y*-1,Scale.z>; #end
      scale <1, Scale.y, 1>
      #debug concat("  Scale: <",vstr(3, Scale, ", ", 0,5),">\n")
      translate Pos
      pigment {rgb <1,RRand(0.1,0.9,Seed2),1>}
      #local N=N+Ang0;
    }
  #end
  //pigment {srgb <0,1,0>}
  translate 0.25*y
}

#end


//--------------------------------------------------------------------------
//------------------------------ the Axes --------------------------------
//------------------------------------------------------------------------
#macro Axis_( AxisLen, Dark_Texture,Light_Texture) 
 union{
    cylinder { <0,-AxisLen,0>,<0,AxisLen,0>,0.01
               texture{checker texture{Dark_Texture } 
                               texture{Light_Texture}
                       translate<0.1,0,0.1>}
             }
    cone{<0,AxisLen,0>,0.04,<0,AxisLen+0.2,0>,0
          texture{Dark_Texture}
         }
     } // end of union                   
#end // of macro "Axis()"
//------------------------------------------------------------------------
#macro AxisXYZ( AxisLenX, AxisLenY, AxisLenZ, Tex_Dark, Tex_Light)
//--------------------- drawing of 3 Axes --------------------------------
union{
#if (AxisLenX != 0)
 object { Axis_(AxisLenX, Tex_Dark, Tex_Light)   rotate< 0,0,-90>}// x-Axis
 text   { ttf "arial.ttf",  "x",  0.25,  0  texture{Tex_Dark} 
          scale 0.25 translate <AxisLenX+0.25, 0.0, 0.0> no_shadow}
#end // of #if 
#if (AxisLenY != 0)
 object { Axis_(AxisLenY, Tex_Dark, Tex_Light)   rotate< 0,0,  0>}// y-Axis
 text   { ttf "arial.ttf",  "y",  0.25,  0  texture{Tex_Dark}    
          scale 0.25 translate <0.0, AxisLenY+0.25, 0.0> no_shadow}
#end // of #if 
#if (AxisLenZ != 0)
 object { Axis_(AxisLenZ, Tex_Dark, Tex_Light)   rotate<90,0,  0>}// z-Axis
 text   { ttf "arial.ttf",  "z",  0.25,  0  texture{Tex_Dark}
          scale 0.25 translate <0.0, 0.0, AxisLenZ+0.25> no_shadow}
#end // of #if 
} // end of union                      
#end// of macro "AxisXYZ( ... )"
//------------------------------------------------------------------------

#declare Texture_A_Dark  = texture {
                               pigment{ color rgb<0.7,0.0,0>}
                               finish { phong 1}
                             }
#declare Texture_A_Light = texture { 
                               pigment{ color rgb<1,1,1>}
                               finish { phong 1}
                             }

object{ AxisXYZ( 2.0, 2.0, 2.0, Texture_A_Dark, Texture_A_Light) scale 1 }
//-------------------------------------------------- end of coordinate axes
